import gymnasium as gym
import minigrid
from rpi.helpers.env import make_minigrid_env

# NOTE:
# https://minigrid.farama.org/environments/minigrid/EmptyEnv/
# MiniGrid-Empty-Random-5x5-v0:
# Each tile is encoded as a 3 dimensional tuple: (OBJECT_IDX, COLOR_IDX, STATE)
# OBJECT_TO_IDX and COLOR_TO_IDX mapping can be found in minigrid/minigrid.py
# STATE refers to the door state with 0=open, 1=closed and 2=locked


if __name__ == '__main__':
    env = make_minigrid_env('MiniGrid-Empty-8x8-v0', seed=0)

    state = env.reset()
    for step in range(256 + 10):
        act = env.action_space.sample()

        if step >= 256:
            import pdb; pdb.set_trace()
        state, reward, terminated, _ = env.step(act)
        print('step', step)
        print('state', state)
        print('reward', reward)

        next_state = state

        if terminated:
            print('done is True!!')
            break